﻿

namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Api.Models;
    using Hims.Shared.UserModels;
    using Hims.Api.Utilities;
    /// <summary>
    /// The patients controller.
    /// </summary>
    [Route("api/encounterslog")]
    public class EncountersLogController : Controller
    {
        // <summary>
        /// the encounters log Service
        /// </summary>
        private readonly IEncountersLogService encountersLogService;

        /// <inheritdoc />
        public EncountersLogController(IEncountersLogService encountersLogService) => this.encountersLogService = encountersLogService;

        /// <summary>
        /// To fetch encounters logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of encounters logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of aencountersLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch")]
        [ProducesResponseType(typeof(IEnumerable<EncountersLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> FetchAsync([FromBody] EncountersLogModel model, [FromHeader] LocationHeader header)
        {
            model = (EncountersLogModel)EmptyFilter.Handler(model);
            var encountersLogs = await encountersLogService.FetchAsync(model);
            if (encountersLogs == null)
            {
                return Ok(-1);
            }

            return Ok(encountersLogs);
        }

        /// <summary>
        /// To insert encounters logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <param name="header"></param>
        /// <returns>
        /// The int.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - int.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("insert")]
        [ProducesResponseType(500)]
        public async Task<int> InsertAsync([FromBody] EncountersLogModel model, [FromHeader] LocationHeader header)
        {
            model = (EncountersLogModel)EmptyFilter.Handler(model);
            model.LocationId = header != null && !string.IsNullOrEmpty(header.LocationId) ? Convert.ToInt32(header.LocationId) : (int?)null;
            model.LogDate = DateTime.UtcNow;
            await encountersLogService.LogAsync(model);
            return 1;
        }
    }
}